﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.BL
{
    public partial class ZSBELearning : Gemini.Core.BL.Base.BusinessLogicPlugIn
    {
        private StudentDocBL _StudentDocBL = null;

        public StudentDocBL StudentDoc
        {
            get
            {
                if (_StudentDocBL == null)
                {
                    _StudentDocBL = new StudentDocBL(this);
                }

                return _StudentDocBL;
            }
        }

        public class StudentDocBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
        {
            public StudentDocBL(ZSBELearning BL) : base(BL) { }

            public List<BL.BO.StudentDoc> Restore()
            {
                return BLP.DAL.StudentDoc.Restore();
            }

            public List<BL.BO.StudentDoc> Restore(BO.Student Student)
            {
                return BLP.DAL.StudentDoc.Restore(Student);
            }

            public BL.BO.StudentDoc New()
            {
                return BLP.DAL.StudentDoc.New();
            }

            public Gemini.Core.BL.Base.MethodResult Save(BL.BO.StudentDoc StudentDoc)
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                if (StudentDoc != null)
                {
                    try
                    {
                        if (StudentDoc.ID.HasValue)
                        {
                            _methodResult.SetSuccess = BLP.DAL.StudentDoc.Update(StudentDoc);
                        }
                        else
                        {
                            _methodResult.SetSuccess = BLP.DAL.StudentDoc.Create(StudentDoc);
                        }   
                    }
                    catch (Exception _exeption)
                    {
                        _methodResult.Add(Gemini.Dictionary.Text.SaveEvents.Exception.Value, _exeption);
                    }
                }
                return _methodResult;
            }

            public Gemini.Core.BL.Base.MethodResult Remove(BL.BO.StudentDoc StudentDoc)
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                if (StudentDoc != null)
                {
                    try
                    {
                        _methodResult.SetSuccess = BLP.DAL.StudentDoc.Remove(StudentDoc);
                    }
                    catch (Exception _exeption)
                    {
                        _methodResult.Add(Gemini.Dictionary.Text.RemoveEvents.Exception.Value,_exeption);
                    }
                }
                return _methodResult;
            }

            public Gemini.Core.BL.Base.MethodResult Remove(BL.BO.Student Student)
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                if (Student != null)
                {
                    try
                    {
                        _methodResult.SetSuccess = BLP.DAL.StudentDoc.Remove(Student);
                    }
                    catch (Exception _exeption)
                    {
                        _methodResult.Add(Gemini.Dictionary.Text.RemoveEvents.Exception.Value, _exeption);
                    }
                }
                return _methodResult;
            }
            /// <summary>
            /// Ozdyskuje certyfikat dla danego studenta o okreslonej nazwie
            /// zakladamy ze student moze miec tylko jeden certyfikat o danej nazwie
            /// </summary>
            /// <param name="Student"></param>
            /// <param name="Name"></param>
            /// <returns></returns>
            public BL.BO.StudentDoc Restore(BO.Student Student, string Name)
            {
                return BLP.DAL.StudentDoc.Restore(Student, Name);
            }
        }
    }
}
